package ibase.marketingCampaign;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;

public class MarketingCampaignIC extends ValidatorEJB {
	E12GenericUtility genericUtility = new E12GenericUtility();

	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag,
			String xtraParams) throws RemoteException, ITMException {
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		System.out.println("xmlString[" + xmlString + "]");
		System.out.println("xmlString1[" + xmlString1 + "]");
		System.out.println("xmlString2[" + xmlString2 + "]");
		try {
			if (xmlString != null && xmlString.trim().length() != 0) {
				dom = genericUtility.parseString(xmlString);
			}
			if (xmlString1 != null && xmlString1.trim().length() != 0) {
				dom1 = genericUtility.parseString(xmlString1);
			}
			if (xmlString2 != null && xmlString2.trim().length() != 0) {
				dom2 = genericUtility.parseString(xmlString2);
			}
			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);
			System.out.println("ErrString: " + errString);
		} catch (Exception e) {
			System.out.println("Exception: SfaTime: wfValData(String xmlString): " + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}
		System.out.println("Returning from SfaTime wfValData");
		return (errString);
	}

	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag,
			String xtraParams) throws RemoteException, ITMException {
		BaseLogger.log("3", getUserInfo(), null, "From git file : wfValData");
		BaseLogger.log("3", getUserInfo(), null, ">>>>>>>>>>>>>>>>>>validation called>>>>>>>>>>>>>>>>>>>");
		System.out.println("Inside SfaTime validation");
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String childNodeName = null;
		String errorString = "";
		String userId = "";
		int ctr = 0;
		int currentFormNo = 0;
		int childNodeListLength = 0;
		int batchCount = 0;
		String startDate;
		String endDate;
		String expEndDate;

		SimpleDateFormat dtFormat = new SimpleDateFormat("dd/MM/yy");

		try {
			conn = getConnection();
			userId = getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode"); // To get user details
			if (objContext != null && objContext.trim().length() > 0) {
				currentFormNo = Integer.parseInt(objContext);
			}

			// this will get all nodelist which start with Detail tag and form number ex.
			// Detail 1, Detail 2, Detail 3
			parentNodeList = dom.getElementsByTagName("Detail" + currentFormNo);

			// this will get single Detail tag at a time. ex. Detail 1
			parentNode = parentNodeList.item(0);

			// this will get all the childnode list which comes under the Detail tag.
			childNodeList = parentNode.getChildNodes();

			// this will get number of child nodes present in Detail tag.
			childNodeListLength = childNodeList.getLength();

			// used to iterate through child nodes
			for (ctr = 0; ctr < childNodeListLength; ctr++) {
				// fetch first tag which comes under the Detail tag ex.state_code
				childNode = childNodeList.item(ctr);

				// this will give name of that first node
				childNodeName = childNode.getNodeName();
				switch (currentFormNo) {
				case 1:
					if (childNodeName.equalsIgnoreCase("campaign_id")) {
						if (childNode.getFirstChild() == null) // this will give you a value of selected node
						{
							errorString = getErrorString("campaign_id", "NLSTATCODE", userId);
							System.out.println("Inside check null condition");
							break;
						} else {
							// used to fetch field value from application form after click on finish
							batchCount = Integer.parseInt((genericUtility.getColumnValue("batch_count", dom)));
							startDate = genericUtility.getColumnValue("start_date", dom);
							endDate = genericUtility.getColumnValue("end_date", dom);
							expEndDate = genericUtility.getColumnValue("exp_end_date", dom);
							startDate = startDate.trim();
							endDate = endDate.trim();
							expEndDate = expEndDate.trim();
							BaseLogger.log("0", null, null, "start date [" + startDate + "]");
							BaseLogger.log("0", null, null, "end date [" + endDate + "]");
							BaseLogger.log("0", null, null, "expected end date [" + endDate + "]");

							try {
								java.util.Date formatedStartDate = dtFormat.parse(startDate);
								java.util.Date formatedEndDate = dtFormat.parse(endDate);
								java.util.Date formatedExpEndDate = dtFormat.parse(expEndDate);

								if (formatedStartDate.compareTo(formatedEndDate) > 0) {
									errorString = getErrorString("start_date", "VMINVPRDST", userId);
								}
								if (formatedStartDate.compareTo(formatedExpEndDate) > 0) {
									errorString = getErrorString("exp_end_date", "VMINVPRDST", userId);
								}
							} catch (ParseException pe) {
								BaseLogger.log("0", null, null, "Parsing error: " + pe.getMessage());
								errorString = "Invalid date format"; // Or handle it as needed
							}

							if (batchCount < 1) {
								// To check length of the state code should less than 5 character
								errorString = getErrorString("batch_count", "VTBATCH2", userId);

							}
						}
					}
				}
			}
		} catch (Exception e) {
			System.out.println("Exception: SfaTime: wfValData: " + e.getMessage() + ":");
			e.printStackTrace();
		} finally {
			closeResources(rs, pstmt, conn);
		}
		return errorString;
	}

	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext,
			String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException {
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		try {
			if (xmlString != null && xmlString.trim().length() != 0) {
				dom = genericUtility.parseString(xmlString);
			}
			if (xmlString1 != null && xmlString1.trim().length() != 0) {
				dom1 = genericUtility.parseString(xmlString1);
			}
			if (xmlString2 != null && xmlString2.trim().length() != 0) {
				dom2 = genericUtility.parseString(xmlString2);
			}
			errString = itemChanged(dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams);
			System.out.println("ErrString :" + errString);
		} catch (Exception e) {
			System.out.println("Exception :SfaTime :itemChanged(String,String):" + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
		}
		System.out.println("returning from SfaTime itemChanged");
		return errString;
	}

	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn,
			String editFlag, String xtraParams) throws RemoteException, ITMException {
		BaseLogger.log("3", getUserInfo(), null, "From git file : itemChange");
		BaseLogger.log("3", getUserInfo(), null, ">>>>>>>>>>>>>>>>>>itemchange called>>>>>>>>>>>>>>>>>>>");
		System.out.println("Inside itemchange");
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		StringBuffer valueXmlString = null;
		int currentFormNo = 0;
		String userId = "";
		try {
			conn = getConnection();
			userId = getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode"); // To get user details after login
			if (objContext != null && objContext.trim().length() > 0) {
				currentFormNo = Integer.parseInt(objContext);
			}

			// start creating xml
			valueXmlString = new StringBuffer("<?xml version=\"1.0\"?><Root><header><editFlag>");
			valueXmlString.append(editFlag).append("</editFlag></header>");
			switch (currentFormNo) {
			case 1:
				valueXmlString.append("<Detail1>");

				if ("campaign_frequency".equalsIgnoreCase(currentColumn.trim())) {
					String campaignFrequency = checkNull(genericUtility.getColumnValue("campaign_frequency", dom));

					// Check for 'O' or 'S'

					if ("O".equalsIgnoreCase(campaignFrequency)) {
						valueXmlString.append("<schedule_id protect='1'>").append("<![CDATA[]]>")
								.append("</schedule_id>\r\n");
					} else if ("S".equalsIgnoreCase(campaignFrequency)) {
						valueXmlString.append("<schedule_id protect='0'>").append("<![CDATA[]]>")
								.append("</schedule_id>\r\n");
					}
				}

				valueXmlString.append("</Detail1>\r\n");
				break;
			}
			valueXmlString.append("</Root>\r\n");
		} catch (Exception e) {
			System.out.println("Exception :SfaTime :itemChanged(Document,String):" + e.getMessage() + ":");
			e.printStackTrace();
		} finally {
			closeResources(rs, pstmt, conn);
		}
		return valueXmlString.toString();
	}

	private void closeResources(ResultSet rs, PreparedStatement pstmt, Connection conn) {
		if (rs != null) {
			try {
				rs.close();
			} catch (SQLException e) {
				e.printStackTrace();
			}
		}
		if (pstmt != null) {
			try {
				pstmt.close();
			} catch (SQLException e) {
				e.printStackTrace();
			}
		}
		if (conn != null) {
			try {
				conn.close();
			} catch (SQLException e) {
				e.printStackTrace();
			}
		}
	}

	private String checkNull(String input) {
		if (input == null) {
			input = "";
		} else {
			input = input.trim();
		}
		return input;
	}
}
